gvExplodingBarrels = {}


-- Parameters:
-- <ul>
-- <li><b>PlayerID</b>: Owner of bomb</li>
-- <li><b>ScriptName</b>: Name of entity</li>
-- <li><b>EffectDistance</b>: Distance the bomb inflics damage</li>
-- <li><b>TriggerDistance</b>: Distance the bomb is activated</li>
-- <li><b>Damage</b>: Base damage</li>
-- </ul>
--
-- @param[type=table] _Data Configuration

function SetupExplodingBarrel(_Data)
	--TODO:CreateVision
    gvExplodingBarrels[_Data.ScriptName] = _Data;

    local ID = ReplaceEntity(_Data.ScriptName, Entities.XD_Tomb1);
    Logic.SetModelAndAnimSet(ID, Models.SalimTrapPlayer);

end

function ExplodingBarrel_Detonate(_ScriptName)
    local Position = GetPosition(_ScriptName);
    Logic.CreateEffect(GGL_Effects.FXExplosionPilgrim, Position.X, Position.Y, 0);
    Logic.CreateEffect(GGL_Effects.FXExplosionShrapnel, Position.X -250, Position.Y +250, 0);
    Logic.CreateEffect(GGL_Effects.FXExplosionShrapnel, Position.X -250, Position.Y -250, 0);
    Logic.CreateEffect(GGL_Effects.FXExplosionShrapnel, Position.X +250, Position.Y +250, 0);
    Logic.CreateEffect(GGL_Effects.FXExplosionShrapnel, Position.X +250, Position.Y -250, 0);

    Logic.SetModelAndAnimSet(GetID(_ScriptName), Models.ThiefBomb);
    local Enemies = ExplodingBarrel_GetEnemies(_ScriptName);
	gvExplodingBarrels[_ScriptName].OnRegen = 0

    for k, v in pairs(Enemies) do
        local Damage = gvExplodingBarrels[_ScriptName].Damage;
        HurtEntitySAVE(k, Damage, 16);
        if MissionCallback_ExplodingBarrelAction then
            MissionCallback_ExplodingBarrelAction(k, Damage);
        end
    end
	--table.insert(_ScriptName)
end

function ExplodingBarrel_GetEnemies(_ScriptName)
    local Enemies = {};
    local OwnerPlayerID = gvExplodingBarrels[_ScriptName].PlayerID;
    local EffectRange = gvExplodingBarrels[_ScriptName].EffectDistance;
    for i= 2, 5, 1 do
        if i ~= OwnerPlayerID and Logic.GetDiplomacyState(i, OwnerPlayerID) == Diplomacy.Hostile then
            local PlayerEntities = GetPlayerEntities(i, 0);
            for k, v in pairs(PlayerEntities) do
                local CheckEntity = true;
                if  Logic.IsEntityInCategory(v, EntityCategories.Soldier) == 0 
                and Logic.IsLeader(v) == 0 and Logic.IsHero(v) == 0 then
                    CheckEntity = false;
                end
                if CheckEntity and IsNear(v, _ScriptName, EffectRange) then
                    local EntityID = v;
                    if Logic.IsEntityInCategory(v, EntityCategories.Soldier) == 1 and Logic.IsLeader(v) == 0 then
                        EntityID = GetLeaderOfSoldier(v);
                    end
                    Enemies[EntityID] = true;
                end
            end
        end
    end
    return Enemies;
end

function ExplodingBarrel_ControlBombs()
	for _tablebarrel,barrelvalue in pairs(gvExplodingBarrels) do
		local Barrel = barrelvalue;
		if Barrel then
			if barrelvalue.OnRegen < 390 then
				barrelvalue.OnRegen = barrelvalue.OnRegen + 1
				if barrelvalue.OnRegen == 390 then
					Logic.SetModelAndAnimSet(GetID(_tablebarrel), Models.SalimTrapPlayer);
				end
			end
			if barrelvalue.Auto == true and barrelvalue.OnRegen == 390 and AreEntitiesOfDiplomacyStateInArea(Barrel.PlayerID, GetPosition(_tablebarrel), Barrel.TriggerDistance) then
				ExplodingBarrel_Detonate(_tablebarrel);
				barrelvalue.OnRegen = 0;
			end
		end
	end
	return false
end

function GetLeaderOfSoldier(_SoldierID)
	if HistoryFlag == true then
		return Logic.GetEntityScriptingValue(_SoldierID, 66)
	else
		return Logic.GetEntityScriptingValue(_SoldierID, 69)
	end
end

function GetPlayerEntities(_PlayerID, _EntityType)
    local PlayerEntities = {}
    if _EntityType ~= 0 then
        local n,eID = Logic.GetPlayerEntities(_PlayerID, _EntityType, 1);
        if (n > 0) then
            local firstEntity = eID;
            repeat
                table.insert(PlayerEntities,eID)
                eID = Logic.GetNextEntityOfPlayerOfType(eID);
            until (firstEntity == eID);
        end
        return PlayerEntities
    elseif _EntityType == 0 then
        for k,v in pairs(Entities) do
            if string.find(k, "PU_") or string.find(k, "PB_") or string.find(k, "CU_") or string.find(k, "CB_")
            or string.find(k, "XD_DarkWall") or string.find(k, "XD_Wall") or string.find(k, "PV_") then
                local n,eID = Logic.GetPlayerEntities(_PlayerID, v, 1);
                if (n > 0) then
                local firstEntity = eID;
                repeat
                    table.insert(PlayerEntities,eID)
                    eID = Logic.GetNextEntityOfPlayerOfType(eID);
                until (firstEntity == eID);
                end
            end
        end
        return PlayerEntities
    end
end

function AreEntitiesOfDiplomacyStateInArea(_player, _position, _range)
	for i = 1,8 do
        if Logic.GetDiplomacyState(_player, i) == Diplomacy.Hostile then
            local Data = {Logic.GetPlayerEntitiesInArea(i, 0, _position.X, _position.Y, _range, 16)};
            table.remove(Data, 1);
            for j= table.getn(Data), 1, -1 do
                if Logic.IsSettler(Data[j]) == 0 and Logic.IsBuilding(Data[j]) == 0 and Logic.IsHero(Data[j]) == 0 then
                    table.remove(Data, j);
                end
            end
            if table.getn(Data) > 0 then
				return true;
			end
		end
	end
	return false;
end

function HurtEntitySAVE(_eID,_dmg,_tarMax,_invulnerable)
	_eID = GetEntityId(_eID)
	if (_dmg <= 0) or (GetHealth(_eID) == 0) then
		return {};
	end
	_tarMax = math.max(1, (_tarMax or 17));
	local aua = _eID;
	local toeten = {};
	if Logic.IsLeader(aua) == 1 then
		local leader = GetLeaderOfSoldier(aua);
		if leader == 0 then
			return {};
		else
			aua = leader;
		end
	end
	if Logic.IsLeader(aua) == 1 then
		local leader = aua;
		local soldiers = {Logic.GetSoldiersAttachedToLeader(leader)}
		local i = 1;
		while (i <= soldiers[1]) and (_dmg > 0) do
			local opfer = soldiers[i+1];
			i = i+1;
			local overkill = (_dmg - Logic.GetEntityHealth(opfer));
			if overkill >= 0 then
				table.insert(toeten, opfer)
				if table.getn(toeten) >= _tarMax then
					_dmg = 0;
					break;
				else
					_dmg = overkill;
				end
			else
				aua = opfer;
				break;
			end
		end
		if leader == aua then
			local overkill = (_dmg - Logic.GetEntityHealth(leader));
			if overkill >= 0 then
				table.insert(toeten, leader)
				_dmg = 0;
			end
		end
	else
		local overkill = (_dmg - Logic.GetEntityHealth(aua));
		if overkill >= 0 then
			table.insert(toeten, aua)
			_dmg = 0;
		end
	end
	gvKillSAVE = gvKillSAVE or {};
	table.insert(gvKillSAVE,toeten);
	if JobIsRunning(gvKillSAVE_JobID) == 0 then
		gvKillSAVE_JobID = StartSimpleHiResJob("ControlKillSAVE");
	end
	if _dmg > 0 then
		if _invulnerable then
			MakeVulnerable(aua);
		end
		Logic.HurtEntity(aua,_dmg);
		if _invulnerable then
			MakeInvulnerable(aua);
		end
	end
	return toeten;
end

function ControlKillSAVE()
	local gv = gvKillSAVE;
	local n = table.getn(gv);
	if n == 0 then
		return true;
	else
		for i = n,1,-1 do
			local t = gv[i];
			for j = 1,table.getn(t) do
				local opfer = t[j];
				if GetHealth(opfer) > 0 then
					MakeVulnerable(opfer);
					SetHealth(opfer,0);
				end
			end
		end
	end
	gvKillSAVE = {};
end

function GetHealth(_Entity)
    local EntityID = GetID(_Entity);
    if not IsExisting(EntityID) then
        return 0;
    end
    return (Logic.GetEntityHealth(EntityID)/Logic.GetEntityMaxHealth(EntityID)) * 100
end
--------------------------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------

function OnRegenNotFull(_name)
	if gvExplodingBarrels[_name].OnRegen < 390 then
		return false
	else
		return true
	end
end

function buttonTitle(_name)
	if gvExplodingBarrels[_name].Auto == true then
		return "Auf manuell stellen."
	else
		return "Auf automatisch stellen."
	end
end

function buttonText(_name)
	if gvExplodingBarrels[_name].Auto == true then
		return "Die Falle auf manuell stellen."
	else
		return "Die Falle auf automatisch stellen."
	end
end

function IsAutomatic(_barrelname)
	if gvExplodingBarrels[_barrelname].Auto == true then
		return false
	else
		return true
	end
end

---------------------------------------------------------
-- Interactive Objects ----------------------------------
---------------------------------------------------------

Interactive = Interactive or {}
Interactive.LastClickedTime = 1000
Tradepost 	= {}

Interactive.Language = (XNetworkUbiCom.Tool_GetCurrentLanguageShortName() == "de" and "de") or "en";

function Interactive.Setup(_table)
	Interactive.IO = Interactive.IO or {}
	local pID = GUI.GetPlayerID()

	-- optinal arguments: set empty callback if callback dosen't exist
	if _table.Callback == nil then
		_table.Callback = function()end
	end

	-- optinal arguments: detect if Range is set and set it to 1000 scm if not
	if _table.Range == nil then
		_table.Range = 1000
	end


	if _table.IsTradepost then
		if not _table.ResourceBuyFlag then
			_table.ResourceBuyFlag = {true,true,true,true,true,}
		end
		if not _table.ResourceSellFlag then
			_table.ResourceSellFlag = {true,true,true,true,true,}
		end
		if not _table.State then
			_table.State = "buy"
		end
	elseif _table.IsChest then
		local callback, rewards, costs, title, text, texture, trigger

		local custom = _table.CustomTexture
		if _table.Texture then
			texture = _table.Texture
		else
			texture = Interactive.Buttons.Chest
		end
		if _table.Triggers then
			trigger = _table.Triggers
		else
			trigger = nil
		end
		if _table.Callback then
			callback = _table.Callback
		else
			callback = function()end
		end
		if _table.Costs then
			costs = _table.Costs
		end
		if _table.Rewards then
			rewards = _table.Rewards
		end
		if _table.Title then
			title = _table.Title
		end
		if _table.Text then
			text = _table.Text
		end

		_table.Button = {}
		_table.Button[3] = {
			Triggers = trigger,
			Texture = texture,
			CustomTexture = custom,
			Callback = callback,
			Costs = costs,
			Rewards = rewards,
			Title = title,
			Text = text,
		}
	elseif _table.IsGate then
		local callback, costs, title, text, texture

		local custom = _table.CustomTexture
		if _table.Texture then
			texture = _table.Texture
		else
			texture = Interactive.Buttons.Lock
		end
		if _table.Costs then
			costs = _table.Costs
		end
		if _table.Callback then
			callback = _table.Callback
		else
			callback = function()end
		end
		if _table.Title then
			title = _table.Title
		end
		if _table.Text then
			text = _table.Text
		end

		_table.Button = {}
		_table.Button[3] = {
			CustomTexture = custom,
			Texture = texture,
			Callback = callback,
			Costs = costs,
			Title = title,
			Text = text,
		}
	elseif _table.IsMercenary then
		assert(_table.Offers,"Mercenary Trader ".._table.Name.." has no offers.")
		assert(table.getn(_table.Offers) <= 6,"Mercenary Trader ".._table.Name.." has to many offers.")
		_table.SingleUse = false

		_table.Button = {}
		for i=1,table.getn(_table.Offers) do
			assert(Interactive.Mercenary[_table.Offers[i][1]],"Mercenary Trader ".._table.Name.." 's offer isn't member of mercenary table.")
			local lang = Interactive.Language
			_table.Button[i] = {
				Texture = Interactive.Mercenary[_table.Offers[i][1]][3],
				Callback = GameCallback_OnInteractionMercenaryCamp,
				Costs = {_table.Offers[i][3],_table.Offers[i][4],_table.Offers[i][5],_table.Offers[i][6],_table.Offers[i][7],_table.Offers[i][8],},
				Title = Interactive.Mercenary[_table.Offers[i][1]][1][lang],
				Text = { de= "Erwerbt eine Einheit dieses Truppentyps. @cr Noch ".._table.Offers[i][2].." Einheiten verfügbar. @cr ",
						 en = "Buy one unit of this troop type. @cr Still ".._table.Offers[i][2].." units aviable. @cr "},
			}
		end
	else
		for i=1,6 do
			if _table.Button[i] then
				if not _table.Button[i].Texture then
					_table.Button[i].Texture = Interactive.Buttons.Standard
				end
			end
		end
	end

	InteractiveID = InteractiveID or 0
	InteractiveID = InteractiveID + 1
	_table.IO_ID = InteractiveID

	local pos = GetPosition(_table.Name)
	local entity = Tools.CreateGroup(4, Entities.CU_BlackKnight_SoldierSword3, 0, pos.X, pos.Y, 0 )
	_table.Marker = GiveEntityName(entity)
	Logic.SetModelAndAnimSet( GetEntityId(_table.Marker),Models.Effects_XF_ExtractStone )
	MakeInvulnerable(_table.Marker)

	-- insert in table
	Interactive.IO[_table.Name] = CopyTableRecursive({},_table);

	-- start control if it isn't running
	if not Interactive.Job then
		Interactive.Job = StartSimpleHiResJob( "INTERACTIVE_CONTROL_INTERACTIVES" )
	end

	-- overwrite key bindings
	if not Interactive.Toggle then
		-- key bindings
		Input.KeyBindDown(Keys.F1, "GUIAction_ToggleMenu_OrigIO('MainMenuWindow',1)", 14, true)
		Input.KeyBindDown(Keys.F2, "GUIAction_ToggleMenu_OrigIO(gvGUI_WidgetID.DiplomacyWindow,1)", 14, true)
		Input.KeyBindDown(Keys.F3, "GUIAction_ToggleMenu_OrigIO(gvGUI_WidgetID.TradeWindow,1)", 14, true)
		Input.KeyBindDown(Keys.F4, "GUIAction_ToggleMenu_OrigIO(gvGUI_WidgetID.QuestWindow,1)", 14, true)
		Input.KeyBindDown(Keys.F5, "GUIAction_ToggleMenu_OrigIO(gvGUI_WidgetID.StatisticsWindow,1)", 14, true)
		-- menu flag
		Interactive.ToggleMenu = 0

		GUIAction_ToggleMenu_OrigIO = GUIAction_ToggleMenu
		GUIAction_ToggleMenu = function(_widget,_flag)
			if not IsBriefingActive() then
				GUIAction_ToggleMenu_OrigIO(_widget,_flag)
				Interactive.ToggleMenu = _flag
				if _widget == gvGUI_WidgetID.QuestWindow then
					local quests = {Logic.GetAllQuests(1)}
					if quests[1] == 0 then
						Interactive.ToggleMenu = 0
					end
				elseif _widget == gvGUI_WidgetID.TradeWindow then
					local tributes = {Logic.GetAllTributes(1)}
					if tributes[1] == 0 then
						Interactive.ToggleMenu = 0
					end
				end
			end
		end
		TributePaid_Action_OrigIO = TributePaid_Action
		TributePaid_Action = function(a)
			TributePaid_Action_OrigIO(a)
			Interactive.ToggleMenu = 0
		end
		Mission_OnSaveGameLoaded_OrigIO = Mission_OnSaveGameLoaded
		Mission_OnSaveGameLoaded = function()
			Mission_OnSaveGameLoaded_OrigIO()

			-- key bindings
			Input.KeyBindDown(Keys.F1, "GUIAction_ToggleMenu_OrigIO('MainMenuWindow',1)", 14, true)
			Input.KeyBindDown(Keys.F2, "GUIAction_ToggleMenu_OrigIO(gvGUI_WidgetID.DiplomacyWindow,1)", 14, true)
			Input.KeyBindDown(Keys.F3, "GUIAction_ToggleMenu_OrigIO(gvGUI_WidgetID.TradeWindow,1)", 14, true)
			Input.KeyBindDown(Keys.F4, "GUIAction_ToggleMenu_OrigIO(gvGUI_WidgetID.QuestWindow,1)", 14, true)
			Input.KeyBindDown(Keys.F5, "GUIAction_ToggleMenu_OrigIO(gvGUI_WidgetID.StatisticsWindow,1)", 14, true)
			-- menu flag
			Interactive.ToggleMenu = 0
		end

		Interactive.Toggle = true
	end

	return InteractiveID
end

function Interactive.Disable(_name)
	local name = Interactive.GetNameByID(_name)
	if Interactive.IO[name].DoNotShowAMarker == nil or Interactive.IO[name].DoNotShowAMarker == false then
		DisableNpcMarker(GetID(Interactive.IO[name].Marker))
		DestroyEntity(Interactive.IO[name].Marker)
	end
	Interactive.IO[name].Disabled = true
end

function Interactive.Enable(_name)
	local name = Interactive.GetNameByID(_name)
	if Interactive.IO[name].DoNotShowAMarker == nil or Interactive.IO[name].DoNotShowAMarker == false then
		if not IsExisting(Interactive.IO[name].Marker) then
			local pos = GetPosition(Interactive.IO[name].Name)
			local entity = Tools.CreateGroup(8, Entities.CU_BlackKnight_SoldierSword3, 0, pos.X, pos.Y, 0 )
			Interactive.IO[name].Marker = GiveEntityName(entity)
			Logic.SetModelAndAnimSet( GetEntityId(Interactive.IO[name].Marker),Models.Effects_XF_ExtractStone )
		end
	end
	Interactive.IO[name].Disabled = false
	Interactive.IO[name].Used = nil
end

function Interactive.Remove(_ID)
	local name = Interactive.GetNameByID(_ID)
	if name ~= nil then
		if IsExisting(Interactive.IO[name].Marker) then
			DestroyEntity(Interactive.IO[name].Marker);
		end
		Interactive.IO[name] = nil
	end
end

function Interactive.GetIDByName(_name)
	if type(_name) == "string" then
		for k,v in pairs(Interactive.IO)do
			if k == _name then
				return Interactive.IO[k].IO_ID
			end
		end
	else
		return _name
	end
end

function Interactive.GetNameByID(_ID)
	if type(_ID) == "number" then
		for k,v in pairs(Interactive.IO)do
			if Interactive.IO[k].IO_ID == _ID then
				return Interactive.IO[k].Name
			end
		end
	else
		return _ID
	end
end

function Interactive.UpdateLanguage(_language)
	local lang = (XNetworkUbiCom.Tool_GetCurrentLanguageShortName() == "de" and "de") or "en";
	Interactive.Language = lang;
end

function Interactive.MousePositionCheck(_X, _Xmax, _Y, _Ymax)
	local mouse = {GUI.GetMousePosition()}
	local size = {GUI.GetScreenSize()}
	local sizeX = size[1]
	local sizeY = size[2]

	if (mouse[1] >= _X/(1366/sizeX) and mouse[1] <= _Xmax/(1366/sizeX)) and (mouse[2] >= _Y/(768/sizeY) and mouse[2] <= _Ymax/(768/sizeY))then
		return true
	end
	return false
end

function Interactive.HideButton()
	XGUIEng.ShowWidget( "BuyHeroWindow", 0)
	XGUIEng.ShowWidget( "TutorialMessageBG", 0)
end

function Interactive.ShowButton(_table,_heroID)
	local pos = GetPosition(_table.Name)
	local flag = Logic.IsMapPositionExplored(GUI.GetPlayerID(),pos.X,pos.Y)
	XGUIEng.ShowWidget( "BuyHeroWindow", flag)
	XGUIEng.ShowWidget( "BuyHeroWindowBackGround", 0 )
	XGUIEng.ShowWidget( "BuyHeroWindowCloseButton", 0 )

	if not _table.IsTradepost then
		for i= 7,12,1 do XGUIEng.ShowWidget( "BuyHeroWindowBuyHero"..i, 0 )end
		XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero1", 70, 305, 40, 40 )
		XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero2", 120, 305, 40, 40 )
		XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero3", 170, 305, 40, 40 )
		XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero4", 220, 305, 40, 40 )
		XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero5", 270, 305, 40, 40 )
		XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero6", 320, 305, 40, 40 )

		if _table.Button[1] then
			XGUIEng.TransferMaterials(_table.Button[1].Texture, "BuyHeroWindowBuyHero1" )
			if _table.Button[1].CustomTexture then
				for j=1,7 do
					XGUIEng.SetMaterialTexture("BuyHeroWindowBuyHero1",(j-1),_table.Button[1].CustomTexture)
				end
			end
			XGUIEng.ShowWidget( "BuyHeroWindowBuyHero1", 1 )
			XGUIEng.DisableButton( "BuyHeroWindowBuyHero1", 0 )
		else
			XGUIEng.ShowWidget( "BuyHeroWindowBuyHero1", 0 )
		end
		if _table.Button[2] then
			XGUIEng.TransferMaterials(_table.Button[2].Texture, "BuyHeroWindowBuyHero2" )
			if _table.Button[2].CustomTexture then
				for j=1,7 do
					XGUIEng.SetMaterialTexture("BuyHeroWindowBuyHero2",(j-1),_table.Button[2].CustomTexture)
				end
			end
			XGUIEng.ShowWidget( "BuyHeroWindowBuyHero2", 1 )
			---------------------
			local trigger = true
			if _table.Button[2].Triggers then
				for j= table.getn(_table.Button[2].Triggers),1,-1 do
					if _table.Button[2].Triggers[j][1](_table.Name) ~= true then
						trigger = false
						--if _table.Button[i].Triggers[j][2] then
							--Message( _table.Button[i].Triggers[j][2] )
						--end
						XGUIEng.DisableButton( "BuyHeroWindowBuyHero2", 1 )
						break;
					end
				end
				if trigger == true then
					XGUIEng.DisableButton( "BuyHeroWindowBuyHero2", 0 )
				end
			end
			--------------------
			--XGUIEng.DisableButton( "BuyHeroWindowBuyHero2", 0 )
		else
			XGUIEng.ShowWidget( "BuyHeroWindowBuyHero2", 0 )
		end
		if _table.Button[3] then
			XGUIEng.TransferMaterials(_table.Button[3].Texture, "BuyHeroWindowBuyHero3" )
			if _table.Button[3].CustomTexture then
				for j=1,7 do
					XGUIEng.SetMaterialTexture("BuyHeroWindowBuyHero3",(j-1),_table.Button[3].CustomTexture)
				end
			end
			XGUIEng.ShowWidget( "BuyHeroWindowBuyHero3", 1 )
			XGUIEng.DisableButton( "BuyHeroWindowBuyHero3", 0 )
		else
			XGUIEng.ShowWidget( "BuyHeroWindowBuyHero3", 0 )
		end
		if _table.Button[4] then
			XGUIEng.TransferMaterials(_table.Button[4].Texture, "BuyHeroWindowBuyHero4" )
			if _table.Button[4].CustomTexture then
				for j=1,7 do
					XGUIEng.SetMaterialTexture("BuyHeroWindowBuyHero4",(j-1),_table.Button[4].CustomTexture)
				end
			end
			XGUIEng.ShowWidget( "BuyHeroWindowBuyHero4", 1 )
			XGUIEng.DisableButton( "BuyHeroWindowBuyHero4", 0 )
		else
			XGUIEng.ShowWidget( "BuyHeroWindowBuyHero4", 0 )
		end
		if _table.Button[5] then
			XGUIEng.TransferMaterials(_table.Button[5].Texture, "BuyHeroWindowBuyHero5" )
			if _table.Button[5].CustomTexture then
				for j=1,7 do
					XGUIEng.SetMaterialTexture("BuyHeroWindowBuyHero5",(j-1),_table.Button[5].CustomTexture)
				end
			end
			XGUIEng.ShowWidget( "BuyHeroWindowBuyHero5", 1 )
			XGUIEng.DisableButton( "BuyHeroWindowBuyHero5", 0 )
		else
			XGUIEng.ShowWidget( "BuyHeroWindowBuyHero5", 0 )
		end
		if _table.Button[6] then
			XGUIEng.TransferMaterials(_table.Button[6].Texture, "BuyHeroWindowBuyHero6" )
			if _table.Button[6].CustomTexture then
				for j=1,7 do
					XGUIEng.SetMaterialTexture("BuyHeroWindowBuyHero6",(j-1),_table.Button[6].CustomTexture)
				end
			end
			XGUIEng.ShowWidget( "BuyHeroWindowBuyHero6", 1 )
			XGUIEng.DisableButton( "BuyHeroWindowBuyHero6", 0 )
		else
			XGUIEng.ShowWidget( "BuyHeroWindowBuyHero6", 0 )
		end

		if (Interactive.MousePositionCheck(Interactive.Buttons.Pos[1][1],Interactive.Buttons.Pos[1][2],Interactive.Buttons.Pos[1][3],Interactive.Buttons.Pos[1][4]) and _table.Button[1])
		or (Interactive.MousePositionCheck(Interactive.Buttons.Pos[2][1],Interactive.Buttons.Pos[2][2],Interactive.Buttons.Pos[2][3],Interactive.Buttons.Pos[2][4]) and _table.Button[2])
		or (Interactive.MousePositionCheck(Interactive.Buttons.Pos[3][1],Interactive.Buttons.Pos[3][2],Interactive.Buttons.Pos[3][3],Interactive.Buttons.Pos[3][4]) and _table.Button[3])
		or (Interactive.MousePositionCheck(Interactive.Buttons.Pos[4][1],Interactive.Buttons.Pos[4][2],Interactive.Buttons.Pos[4][3],Interactive.Buttons.Pos[4][4]) and _table.Button[4])
		or (Interactive.MousePositionCheck(Interactive.Buttons.Pos[5][1],Interactive.Buttons.Pos[5][2],Interactive.Buttons.Pos[5][3],Interactive.Buttons.Pos[5][4]) and _table.Button[5])
		or (Interactive.MousePositionCheck(Interactive.Buttons.Pos[6][1],Interactive.Buttons.Pos[6][2],Interactive.Buttons.Pos[6][3],Interactive.Buttons.Pos[6][4]) and _table.Button[6])then
			XGUIEng.ShowWidget( "BuyHeroWindowHeadline", 1)
			XGUIEng.ShowWidget( "BuyHeroWindowInfoLine", 1)
			XGUIEng.ShowWidget( "TutorialMessageBG", flag)
			XGUIEng.SetWidgetPositionAndSize( "TutorialMessageBG", 340, 335, 470, 140 )
			XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindow", 290, 295, 450, 170 )
			XGUIEng.SetWidgetPositionAndSize( "BuyHeroLine1", 0, 0, 450, 170 )
			XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowHeadline", 5, 0, 450, 65 )
			XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowInfoLine", 0, 20, 450, 45 )
			XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero1", 70, 140, 40, 40 )
			XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero2", 120, 140, 40, 40 )
			XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero3", 170, 140, 40, 40 )
			XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero4", 220, 140, 40, 40 )
			XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero5", 270, 140, 40, 40 )
			XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero6", 320, 140, 40, 40 )
		else
			XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindow",290, 395, 450, 40 )
			XGUIEng.ShowWidget( "BuyHeroWindowHeadline", 0)
			XGUIEng.ShowWidget( "BuyHeroWindowInfoLine", 0)
			XGUIEng.ShowWidget( "TutorialMessageBG", 0)
		end

		BuyHeroWindow_Action_BuyHero = function( _hero )
			if Interactive.LastClickedTime+500 < Logic.GetTimeMs() then
				Interactive.LastClickedTime = Logic.GetTimeMs()

				if _hero == Entities.PU_Hero1c then
					GameCallback_InteractiveObjectActivated(_table,1,_heroID)
				elseif _hero == Entities.PU_Hero5 then
					GameCallback_InteractiveObjectActivated(_table,2,_heroID)
				elseif _hero == Entities.PU_Hero4 then
					GameCallback_InteractiveObjectActivated(_table,3,_heroID)
				elseif _hero == Entities.PU_Hero3 then
					GameCallback_InteractiveObjectActivated(_table,4,_heroID)
				elseif _hero == Entities.PU_Hero2 then
					GameCallback_InteractiveObjectActivated(_table,5,_heroID)
				elseif _hero == Entities.PU_Hero6 then
					GameCallback_InteractiveObjectActivated(_table,6,_heroID)
				end
			end
		end

		BuyHeroWindow_UpdateInfoLine = function()
			for i= 1,6 do
				if _table.Button[i] then
					if _table.Button[i] and Interactive.MousePositionCheck(Interactive.Buttons.Pos[i][1],Interactive.Buttons.Pos[i][2],Interactive.Buttons.Pos[i][3],Interactive.Buttons.Pos[i][4]) then
						local pID = GUI.GetPlayerID()
						local lang = Interactive.Language
						local text = ""
						local title = ""

						-- optional arguments: detect if Text is set and assign Standard description if not
						if _table.Button[i].Text ~= nil then
							if type(_table.Button[i].Text) == "table" then
								text = _table.Button[i].Text[lang].." @cr "
							elseif type(_table.Button[i].Text) == "function" then
								text = _table.Button[i].Text(_table.Name).." @cr "
								if XGUIEng.IsButtonDisabled("BuyHeroWindowBuyHero2") == 1 then
									--TODO check auf welche Bedingung.
									if _table.Button[i].Triggers[1][1](_table.ScriptName) == true then
										text = text.."@color:255,31,8 ".._table.Button[i].Triggers[1][2]
									elseif _table.Button[i].Triggers[2][1](_table.ScriptName) == true then
										text = text.."@color:255,31,8 ".._table.Button[i].Triggers[2][2]
									end
								end
							else
								text = _table.Button[i].Text.." @cr "
							end
						else
							if _table.IsChest then
								text = Interactive.Standard.Chest.Text[lang].." @cr "
							elseif _table.IsGate then
								text = Interactive.Standard.Gate.Text[lang].." @cr "
							else
								text = Interactive.Standard.Custom.Text[lang].." @cr "
							end
						end

						-- optional arguments: detect if Title is set and assign Standard description if not
						if _table.Button[i].Title ~= nil then
							if type(_table.Button[i].Title) == "table" then
								title = _table.Button[i].Title[lang]
							elseif type(_table.Button[i].Title) == "function" then
								title = _table.Button[i].Title(_table.Name)
							else
								title = _table.Button[i].Title
							end
						else
							if _table.IsChest then
								title = Interactive.Standard.Chest.Title[lang].." "
							elseif _table.IsGate then
								title = Interactive.Standard.Gate.Title[lang].." "
							else
								title = Interactive.Standard.Custom.Title[lang].." "
							end
						end

						-- optional arguments: detect if Costs is set and add costs to description if they set
						if _table.Button[i].Costs then
							local costs = {"","","","","","","",}
							if _table.Button[i].Costs[1]>0 then costs[1] = ""..Tradepost.Money[lang].." : "..GibTTGold( _table.Button[i].Costs[1], pID )end
							if _table.Button[i].Costs[2]>0 then costs[2] = ""..Tradepost.Clay[lang].." : "..GibTTLehm( _table.Button[i].Costs[2], pID )end
							if _table.Button[i].Costs[3]>0 then costs[3] = ""..Tradepost.Wood[lang].." : "..GibTTHolz( _table.Button[i].Costs[3], pID )end
							if _table.Button[i].Costs[4]>0 then costs[4] = ""..Tradepost.Stone[lang].." : "..GibTTStein( _table.Button[i].Costs[4], pID )end
							if _table.Button[i].Costs[5]>0 then costs[5] = ""..Tradepost.Iron[lang].." : "..GibTTEisen( _table.Button[i].Costs[5], pID )end
							if _table.Button[i].Costs[6]>0 then costs[6] = ""..Tradepost.Sulfur[lang].." : "..GibTTSchwefel( _table.Button[i].Costs[6], pID )end
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(title) )
							XGUIEng.SetText( "BuyHeroWindowInfoLine", Umlaute(text.." @color:180,180,180 Kosten: @color:255,255,255 "..
												" "..costs[1].." "..costs[2].." "..costs[3].." "..costs[4].." "..costs[5].." "..costs[6]))
						else
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(title) )
							XGUIEng.SetText( "BuyHeroWindowInfoLine", Umlaute(text) )
						end
					end
				end
			end
		end

	else

		for i= 7,12,1 do XGUIEng.ShowWidget( "BuyHeroWindowBuyHero"..i, 0 )end
		if _table.ForbidSwitching then
			XGUIEng.ShowWidget( "BuyHeroWindowBuyHero6", 0 )
		else
			XGUIEng.ShowWidget( "BuyHeroWindowBuyHero6", 1 )
			XGUIEng.DisableButton( "BuyHeroWindowBuyHero6", 0 )
		end

		XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero1", 50, 5, 40, 40 )
		XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero2", 100, 5, 40, 40 )
		XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero3", 150, 5, 40, 40 )
		XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero4", 200, 5, 40, 40 )
		XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero5", 250, 5, 40, 40 )
		XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero6", 350, 5, 40, 40 )

		XGUIEng.TransferMaterials( "Statistics_SubResources_Clay", "BuyHeroWindowBuyHero1" )
		XGUIEng.TransferMaterials( "Statistics_SubResources_Wood", "BuyHeroWindowBuyHero2" )
		XGUIEng.TransferMaterials( "Statistics_SubResources_Stone", "BuyHeroWindowBuyHero3" )
		XGUIEng.TransferMaterials( "Statistics_SubResources_Iron", "BuyHeroWindowBuyHero4" )
		XGUIEng.TransferMaterials( "Statistics_SubResources_Sulphur", "BuyHeroWindowBuyHero5" )

		if _table.State == "buy" then
			for i=1,5 do
				if _table.ResourceBuyFlag[i] then
					XGUIEng.ShowWidget( "BuyHeroWindowBuyHero"..i, 1 )
					XGUIEng.DisableButton( "BuyHeroWindowBuyHero"..i, 0 )
				else
					XGUIEng.ShowWidget( "BuyHeroWindowBuyHero"..i, 0 )
				end
			end

			if (Interactive.MousePositionCheck(546, 596, 475, 515) and _table.ResourceBuyFlag[1])
			or (Interactive.MousePositionCheck(616, 666, 475, 515) and _table.ResourceBuyFlag[2])
			or (Interactive.MousePositionCheck(686, 736, 475, 515) and _table.ResourceBuyFlag[3])
			or (Interactive.MousePositionCheck(746, 796, 475, 515) and _table.ResourceBuyFlag[4])
			or (Interactive.MousePositionCheck(816, 866, 475, 515) and _table.ResourceBuyFlag[5])
			or (Interactive.MousePositionCheck(946, 996, 475, 515) and not(_table.ForbidSwitching))then
				XGUIEng.ShowWidget( "BuyHeroWindowHeadline", 1)
				XGUIEng.ShowWidget( "BuyHeroWindowInfoLine", 1)
				XGUIEng.ShowWidget( "TutorialMessageBG", flag)
				XGUIEng.SetWidgetPositionAndSize( "TutorialMessageBG", 340, 335, 470, 140 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindow", 290, 295, 450, 170 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroLine1", 0, 0, 450, 170 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowHeadline", 5, 0, 450, 65 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowInfoLine", 0, 20, 450, 45 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero1", 50, 140, 40, 40 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero2", 100, 140, 40, 40 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero3", 150, 140, 40, 40 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero4", 200, 140, 40, 40 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero5", 250, 140, 40, 40 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero6", 350, 140, 40, 40 )
			else
				XGUIEng.ShowWidget( "BuyHeroWindowHeadline", 0)
				XGUIEng.ShowWidget( "BuyHeroWindowInfoLine", 0)
				XGUIEng.ShowWidget( "TutorialMessageBG", 0)
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindow", 290, 395, 450, 40 )
			end
		else
			for i=1,5 do
				if _table.ResourceSellFlag[i] then
					XGUIEng.ShowWidget( "BuyHeroWindowBuyHero"..i, 1 )
					XGUIEng.DisableButton( "BuyHeroWindowBuyHero"..i, 0 )
				else
					XGUIEng.ShowWidget( "BuyHeroWindowBuyHero"..i, 0 )
				end
			end

			if (Interactive.MousePositionCheck(546, 596, 475, 515) and _table.ResourceSellFlag[1])
			or (Interactive.MousePositionCheck(616, 666, 475, 515) and _table.ResourceSellFlag[2])
			or (Interactive.MousePositionCheck(686, 736, 475, 515) and _table.ResourceSellFlag[3])
			or (Interactive.MousePositionCheck(746, 796, 475, 515) and _table.ResourceSellFlag[4])
			or (Interactive.MousePositionCheck(816, 866, 475, 515) and _table.ResourceSellFlag[5])
			or (Interactive.MousePositionCheck(946, 996, 475, 515) and not(_table.ForbidSwitching))then
				XGUIEng.ShowWidget( "BuyHeroWindowHeadline", 1)
				XGUIEng.ShowWidget( "BuyHeroWindowInfoLine", 1)
				XGUIEng.ShowWidget( "TutorialMessageBG", flag)
				XGUIEng.SetWidgetPositionAndSize( "TutorialMessageBG", 340, 335, 470, 140 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindow", 290, 295, 450, 170 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroLine1", 0, 0, 450, 170 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowHeadline", 5, 0, 450, 65 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowInfoLine", 0, 20, 450, 45 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero1", 50, 140, 40, 40 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero2", 100, 140, 40, 40 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero3", 150, 140, 40, 40 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero4", 200, 140, 40, 40 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero5", 250, 140, 40, 40 )
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindowBuyHero6", 350, 140, 40, 40 )
			else
				XGUIEng.ShowWidget( "BuyHeroWindowHeadline", 0)
				XGUIEng.ShowWidget( "BuyHeroWindowInfoLine", 0)
				XGUIEng.ShowWidget( "TutorialMessageBG", 0)
				XGUIEng.SetWidgetPositionAndSize( "BuyHeroWindow", 290, 395, 450, 40 )
			end
		end

		BuyHeroWindow_Action_BuyHero = function( _hero )
			local pID = GUI.GetPlayerID()
			if _table.State == "buy" then
				if _hero == Entities.PU_Hero1c then
					GameCallback_OnClickBuy(pID,1,_table,_heroID)
				elseif _hero == Entities.PU_Hero5 then
					GameCallback_OnClickBuy(pID,2,_table,_heroID)
				elseif _hero == Entities.PU_Hero4 then
					GameCallback_OnClickBuy(pID,3,_table,_heroID)
				elseif _hero == Entities.PU_Hero3 then
					GameCallback_OnClickBuy(pID,4,_table,_heroID)
				elseif _hero == Entities.PU_Hero2 then
					GameCallback_OnClickBuy(pID,5,_table,_heroID)
				elseif _hero == Entities.PU_Hero6 then
					GameCallback_OnChangeState(pID,"sell",_table,_heroID)
				end
			elseif _table.State == "sell" then
				if _hero == Entities.PU_Hero1c then
					GameCallback_OnClickSell(pID,1,_table,_heroID)
				elseif _hero == Entities.PU_Hero5 then
					GameCallback_OnClickSell(pID,2,_table,_heroID)
				elseif _hero == Entities.PU_Hero4 then
					GameCallback_OnClickSell(pID,3,_table,_heroID)
				elseif _hero == Entities.PU_Hero3 then
					GameCallback_OnClickSell(pID,4,_table,_heroID)
				elseif _hero == Entities.PU_Hero2 then
					GameCallback_OnClickSell(pID,5,_table,_heroID)
				elseif _hero == Entities.PU_Hero6 then
					GameCallback_OnChangeState(pID,"buy",_table,_heroID)
				end
			end
		end

		BuyHeroWindow_UpdateInfoLine = function()
			local pID = GUI.GetPlayerID()
			if _table.State == "buy" then
				if Interactive.MousePositionCheck(546, 596, 475, 515) then
					if _table.Title then
						if type(_table.Title) == "table" then
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title[Interactive.Language]) )
						else
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title) )
						end
					else
						XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(Tradepost.Title[Interactive.Language]) )
					end
					XGUIEng.SetText( "BuyHeroWindowInfoLine", Umlaute(Tradepost.Text1[Interactive.Language]..""..
					" @cr @color:255,255,255 "..GibTTGold(Tradepost.PriceBuy[1],pID).." @color:180,180,180 "..
					""..Tradepost.Money[Interactive.Language]))
				elseif Interactive.MousePositionCheck(616, 666, 475, 515)then
					if _table.Title then
						if type(_table.Title) == "table" then
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title[Interactive.Language]) )
						else
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title) )
						end
					else
						XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(Tradepost.Title[Interactive.Language]) )
					end
					XGUIEng.SetText( "BuyHeroWindowInfoLine", Umlaute(Tradepost.Text1[Interactive.Language]..""..
					" @cr @color:255,255,255 "..GibTTGold(Tradepost.PriceBuy[2],pID).." @color:180,180,180 "..
					""..Tradepost.Money[Interactive.Language]))
				elseif Interactive.MousePositionCheck(686, 736, 475, 515) then
					if _table.Title then
						if type(_table.Title) == "table" then
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title[Interactive.Language]) )
						else
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title) )
						end
					else
						XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(Tradepost.Title[Interactive.Language]) )
					end
					XGUIEng.SetText( "BuyHeroWindowInfoLine", Umlaute(Tradepost.Text1[Interactive.Language]..""..
					" @cr @color:255,255,255 "..GibTTGold(Tradepost.PriceBuy[3],pID).." @color:180,180,180 "..
					""..Tradepost.Money[Interactive.Language]))
				elseif Interactive.MousePositionCheck(746, 796, 475, 515) then
					if _table.Title then
						if type(_table.Title) == "table" then
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title[Interactive.Language]) )
						else
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title) )
						end
					else
						XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(Tradepost.Title[Interactive.Language]) )
					end
					XGUIEng.SetText( "BuyHeroWindowInfoLine", Umlaute(Tradepost.Text1[Interactive.Language]..""..
					" @cr @color:255,255,255 "..GibTTGold(Tradepost.PriceBuy[4],pID).." @color:180,180,180 "..
					""..Tradepost.Money[Interactive.Language]))
				elseif Interactive.MousePositionCheck(816, 866, 475, 515) then
					if _table.Title then
						if type(_table.Title) == "table" then
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title[Interactive.Language]) )
						else
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title) )
						end
					else
						XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(Tradepost.Title[Interactive.Language]) )
					end
					XGUIEng.SetText( "BuyHeroWindowInfoLine", Umlaute(Tradepost.Text1[Interactive.Language]..""..
					" @cr @color:255,255,255 "..GibTTGold(Tradepost.PriceBuy[5],pID).." @color:180,180,180 "..
					""..Tradepost.Money[Interactive.Language]))
				elseif Interactive.MousePositionCheck(946, 996, 475, 515) then
					if _table.Title then
						if type(_table.Title) == "table" then
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title[Interactive.Language]) )
						else
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title) )
						end
					else
						XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(Tradepost.Title[Interactive.Language]) )
					end
					XGUIEng.SetText( "BuyHeroWindowInfoLine", Umlaute(Tradepost.Text3[Interactive.Language]))
				end
			elseif _table.State == "sell" then
				if Interactive.MousePositionCheck(546, 596, 475, 515) then
					if _table.Title then
						if type(_table.Title) == "table" then
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title[Interactive.Language]) )
						else
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title) )
						end
					else
						XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(Tradepost.Title[Interactive.Language]) )
					end
					XGUIEng.SetText( "BuyHeroWindowInfoLine", Umlaute(Tradepost.Text2[Interactive.Language]..""..
					" @cr @color:255,255,255 "..GibTTLehm(Tradepost.PriceSell[1],pID).." @color:180,180,180 "..
					""..Tradepost.Clay[Interactive.Language]))
				elseif Interactive.MousePositionCheck(616, 666, 475, 515)then
					if _table.Title then
						if type(_table.Title) == "table" then
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title[Interactive.Language]) )
						else
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title) )
						end
					else
						XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(Tradepost.Title[Interactive.Language]) )
					end
					XGUIEng.SetText( "BuyHeroWindowInfoLine", Umlaute(Tradepost.Text2[Interactive.Language]..""..
					" @cr @color:255,255,255 "..GibTTHolz(Tradepost.PriceSell[2],pID).." @color:180,180,180 "..
					""..Tradepost.Wood[Interactive.Language]))
				elseif Interactive.MousePositionCheck(686, 736, 475, 515) then
					if _table.Title then
						if type(_table.Title) == "table" then
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title[Interactive.Language]) )
						else
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title) )
						end
					else
						XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(Tradepost.Title[Interactive.Language]) )
					end
					XGUIEng.SetText( "BuyHeroWindowInfoLine", Umlaute(Tradepost.Text2[Interactive.Language]..""..
					" @cr @color:255,255,255 "..GibTTStein(Tradepost.PriceSell[3],pID).." @color:180,180,180 "..
					""..Tradepost.Stone[Interactive.Language]))
				elseif Interactive.MousePositionCheck(746, 796, 475, 515) then
					if _table.Title then
						if type(_table.Title) == "table" then
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title[Interactive.Language]) )
						else
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title) )
						end
					else
						XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(Tradepost.Title[Interactive.Language]) )
					end
					XGUIEng.SetText( "BuyHeroWindowInfoLine", Umlaute(Tradepost.Text2[Interactive.Language]..""..
					" @cr @color:255,255,255 "..GibTTEisen(Tradepost.PriceSell[4],pID).." @color:180,180,180 "..
					""..Tradepost.Iron[Interactive.Language]))
				elseif Interactive.MousePositionCheck(816, 866, 475, 515) then
					if _table.Title then
						if type(_table.Title) == "table" then
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title[Interactive.Language]) )
						else
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title) )
						end
					else
						XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(Tradepost.Title[Interactive.Language]) )
					end
					XGUIEng.SetText( "BuyHeroWindowInfoLine", Umlaute(Tradepost.Text2[Interactive.Language]..""..
					" @cr @color:255,255,255 "..GibTTSchwefel(Tradepost.PriceSell[5],pID).." @color:180,180,180 "..
					""..Tradepost.Sulfur[Interactive.Language]))
				elseif Interactive.MousePositionCheck(946, 996, 475, 515) then
					if _table.Title then
						if type(_table.Title) == "table" then
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title[Interactive.Language]) )
						else
							XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(_table.Title) )
						end
					else
						XGUIEng.SetText( "BuyHeroWindowHeadline", Umlaute(Tradepost.Title[Interactive.Language]) )
					end
					XGUIEng.SetText( "BuyHeroWindowInfoLine", Umlaute(Tradepost.Text3[Interactive.Language]))
				end
			end
		end
	end

	BuyHeroWindow_Update_BuyHero = function()
		if _table.State then
			if _table.State == "buy" then
				XGUIEng.TransferMaterials( "Trade_Market_IncreaseSulfur", "BuyHeroWindowBuyHero6" )
			elseif _table.State == "sell" then
				XGUIEng.TransferMaterials( "Trade_Market_DecreaseSulfur", "BuyHeroWindowBuyHero6" )
			end
		end
	end
end

-- on object is clicked
function GameCallback_InteractiveObjectActivated(_table,i,_heroID)
	local lang = Interactive.Language
	local pID = GUI.GetPlayerID()
	local trigger = true
	--[[
	if _table.Button[i].Triggers then
		for j= table.getn(_table.Button[i].Triggers),1,-1 do
			if _table.Button[i].Triggers[j][1](_table.Name) ~= true then
				trigger = false
				if _table.Button[i].Triggers[j][2] then
					Message( _table.Button[i].Triggers[j][2] )
				end
			end
		end
	end
	]]
	if trigger == true then
		if _table.Button[i].Costs then
			if GetGold(pID)>= _table.Button[i].Costs[1] and GetClay(pID)>= _table.Button[i].Costs[2]
			and GetWood(pID)>= _table.Button[i].Costs[3] and GetStone(pID)>= _table.Button[i].Costs[4]
			and GetIron(pID)>= _table.Button[i].Costs[5] and GetSulfur(pID)>= _table.Button[i].Costs[6] then
				AddGold( pID, -_table.Button[i].Costs[1] )
				AddClay( pID, -_table.Button[i].Costs[2] )
				AddWood( pID, -_table.Button[i].Costs[3] )
				AddStone( pID, -_table.Button[i].Costs[4] )
				AddIron( pID, -_table.Button[i].Costs[5] )
				AddSulfur( pID, -_table.Button[i].Costs[6] )
				if _table.Button[i].Rewards then
					Tools.GiveResouces( pID, _table.Button[i].Rewards[1], _table.Button[i].Rewards[2], _table.Button[i].Rewards[3], _table.Button[i].Rewards[4], _table.Button[i].Rewards[5], _table.Button[i].Rewards[6] )
					if Logic.GetEntityType(GetEntityId(_table.Name)) == Entities.XD_ChestClose then
						ReplaceEntity(_table.Name,Entities.XD_ChestOpen)
					end
					Message(Umlaute(Interactive.Standard.Chest.Found[lang]))
				end

				if _table.IsGate then
					GameCallback_OnInteractionGate(_table,_heroID)
				end

				_table.Button[i].Callback(_table,i,_heroID)

				if (_table.DoNotShowAMarker == nil or _table.DoNotShowAMarker == false)
				and (_table.SingleUse == true or _table.SingleUse == nil) then
					MakeVulnerable(_table.Marker)
					DestroyEntity(_table.Marker)
				end
				if _table.SingleUse == true or _table.SingleUse == nil then
					_table.Used = true
				end
			else
				Sound.PlayQueuedFeedbackSound( Sounds.VoicesMentor_INFO_NotEnough )
				Message(Umlaute(Interactive.Standard.NotEnough1[lang]))
			end
		else
			if _table.Button[i].Rewards then
				Tools.GiveResouces( pID, _table.Button[i].Rewards[1], _table.Button[i].Rewards[2], _table.Button[i].Rewards[3], _table.Button[i].Rewards[4], _table.Button[i].Rewards[5], _table.Button[i].Rewards[6] )
				if Logic.GetEntityType(GetEntityId(_table.Name)) == Entities.XD_ChestClose then
					ReplaceEntity(_table.Name,Entities.XD_ChestOpen)
				end
				Message(Umlaute(Interactive.Standard.Chest.Found[lang]))
			end

			if _table.IsGate then
				GameCallback_OnInteractionGate(_table,_heroID)
			end

			_table.Button[i].Callback(_table,i,_heroID)

			if (_table.DoNotShowAMarker == nil or _table.DoNotShowAMarker == false)
			and (_table.SingleUse == true or _table.SingleUse == nil) then
				MakeVulnerable(_table.Marker)
				DestroyEntity(_table.Marker)
			end
			if _table.SingleUse == true or _table.SingleUse == nil then
				_table.Used = true
			end
		end
	end
end

-- called when a gate is used
function GameCallback_OnInteractionGate(_table,_heroID)
	if Logic.GetEntityType(GetEntityId(_table.Name)) == Entities.XD_DarkWallStraightGate then
		ReplaceEntity(_table.Name,Entities.XD_DarkWallStraightGate_Closed)
	elseif Logic.GetEntityType(GetEntityId(_table.Name)) == Entities.XD_WallStraightGate then
		ReplaceEntity(_table.Name,Entities.XD_WallStraightGate_Closed)
	elseif Logic.GetEntityType(GetEntityId(_table.Name)) == Entities.XD_PalisadeGate2 then
		ReplaceEntity(_table.Name,Entities.XD_PalisadeGate1)
	elseif Logic.GetEntityType(GetEntityId(_table.Name)) == Entities.XD_DarkWallStraightGate_Closed then
		ReplaceEntity(_table.Name,Entities.XD_DarkWallStraightGate)
	elseif Logic.GetEntityType(GetEntityId(_table.Name)) == Entities.XD_WallStraightGate_Closed then
		ReplaceEntity(_table.Name,Entities.XD_WallStraightGate)
	elseif Logic.GetEntityType(GetEntityId(_table.Name)) == Entities.XD_PalisadeGate1 then
		ReplaceEntity(_table.Name,Entities.XD_PalisadeGate2)
	end
end

-- called when a transaction is possible
function GameCallback_FullfillTransactionSell(_pID,_resource,_resourceRaw,_table,_heroID)
	local resourceRaw = Logic.GetPlayersGlobalResource(_pID,_resourceRaw)
	local resource = Logic.GetPlayersGlobalResource(_pID,resource)
	local position = Interactive.ResourceCount[_resource]
	local cost = Tradepost.PriceSell[position]

	if (resource+resourceRaw) >= cost then
		-- sub from players res
		local sub = cost-resource
		if sub > 0 then
			Logic.SubFromPlayersGlobalResource(_pID,_resource,resource)
			Logic.SubFromPlayersGlobalResource(_pID,_resourceRaw,sub)
		else
			Logic.SubFromPlayersGlobalResource(_pID,_resource,cost)
		end
		-- give ware
		if _table.RawResources then
			Logic.AddToPlayersGlobalResource(_pID,ResourceType.GoldRaw,250)
		else
			Logic.AddToPlayersGlobalResource(_pID,ResourceType.Gold,250)
		end
		-- set values
		Tradepost.PriceSell[position] = Tradepost.PriceSell[position] + Tradepost.Deflation
		Tradepost.PriceBuy[position] = Tradepost.PriceBuy[position] - Tradepost.Deflation
		Tradepost.TransactionSell[position] = Tradepost.TransactionSell[position] + 1
		if Tradepost.PriceBuy[position] < 5 then
			Tradepost.PriceBuy[position] = 5
		end
	end
end

-- called when the button is pressed
function GameCallback_OnClickSell(_pID,_position,_table,_heroID)
	-- get resource
	local resourceRaw = ResourceType["ClayRaw"]
	local resource = ResourceType["Clay"]
	if _position == 2 then
		resourceRaw = ResourceType["WoodRaw"]
		resource = ResourceType["Wood"]
	elseif _position == 3 then
		resourceRaw = ResourceType["StoneRaw"]
		resource = ResourceType["Stone"]
	elseif _position == 4 then
		resourceRaw = ResourceType["IronRaw"]
		resource = ResourceType["Iron"]
	elseif _position == 5 then
		resourceRaw = ResourceType["SulfurRaw"]
		resource = ResourceType["Sulfur"]
	end
	-- call trade function
	GameCallback_FullfillTransactionSell(_pID,resource,resourceRaw,_table,_heroID)
end

-- called when a transaction is possible
function GameCallback_FullfillTransactionBuy(_pID,_resource,_resourceRaw,_table,_heroID)
	local resourceRaw = Logic.GetPlayersGlobalResource(_pID,ResourceType.GoldRaw)
	local resource = Logic.GetPlayersGlobalResource(_pID,ResourceType.Gold)
	local position = Interactive.ResourceCount[_resource]
	local cost = Tradepost.PriceBuy[position]

	if (resource+resourceRaw) >= cost then
		-- sub from players res
		local sub = cost-resource
		if sub > 0 then
			Logic.SubFromPlayersGlobalResource(_pID,ResourceType.Gold,resource)
			Logic.SubFromPlayersGlobalResource(_pID,ResourceType.GoldRaw,sub)
		else
			Logic.SubFromPlayersGlobalResource(_pID,ResourceType.Gold,cost)
		end
		-- give ware
		if _table.RawResources then
			Logic.AddToPlayersGlobalResource(_pID,_resourceRaw,250)
		else
			Logic.AddToPlayersGlobalResource(_pID,_resource,250)
		end
		-- set values
		Tradepost.PriceSell[position] = Tradepost.PriceSell[position] - Tradepost.Deflation
		Tradepost.PriceBuy[position] = Tradepost.PriceBuy[position] + Tradepost.Inflation
		Tradepost.TransactionBuy[position] = Tradepost.TransactionBuy[position] + 1
		if Tradepost.PriceSell[position] < 5 then
			Tradepost.PriceSell[position] = 5
		end
	end
end

-- called when the button is pressed
function GameCallback_OnClickBuy(_pID,_position,_table,_heroID)
	-- get resource
	local resourceRaw = ResourceType["ClayRaw"]
	local resource = ResourceType["Clay"]
	if _position == 2 then
		resourceRaw = ResourceType["WoodRaw"]
		resource = ResourceType["Wood"]
	elseif _position == 3 then
		resourceRaw = ResourceType["StoneRaw"]
		resource = ResourceType["Stone"]
	elseif _position == 4 then
		resourceRaw = ResourceType["IronRaw"]
		resource = ResourceType["Iron"]
	elseif _position == 5 then
		resourceRaw = ResourceType["SulfurRaw"]
		resource = ResourceType["Sulfur"]
	end
	-- call trade function
	GameCallback_FullfillTransactionBuy(_pID,resource,resourceRaw,_table,_heroID)
end

-- called when the state of a tradepost is changed
function GameCallback_OnChangeState(_pID,_state,_table,_heroID)
	assert(type(_state) == "string")
	_table.State = _state
end

-- called when mercenaries are byued
function GameCallback_OnInteractionMercenaryCamp(_IO,_index,_hero)
	local i = _index
	local pID = GUI.GetPlayerID()
	local lang = Interactive.Language
	local attraction = Logic.GetPlayerAttractionLimit(pID)-Logic.GetPlayerAttractionUsage(pID)
	local necrassyPlaces = Interactive.Mercenary[_IO.Offers[i][1]][2] +1
	local soldiers = necrassyPlaces -1
	if _IO.IgnoreLimit then
		local pos = GetPosition(_IO.Spawn)
		local rotation = Logic.GetEntityOrientation(GetEntityId(_IO.Name))
		local troop = AI.Entity_CreateFormation(pID,_IO.Offers[i][1],nil,0,pos.X,pos.Y, 0, 0,_IO.Offers[i][9],0)
		Tools.CreateSoldiersForLeader(troop,soldiers)
		Move(troop,troop)
		_IO.Offers[i][2] = _IO.Offers[i][2] -1
		_IO.Button[i].Text = {
			de= "Erwerbt eine Einheit dieses Truppentyps. @cr Noch ".._IO.Offers[i][2].." Einheiten verfügbar. @cr ",
			en = "Buy one battalion of this unit type. @cr Still ".._IO.Offers[i][2].." battalions aviable. @cr "
		}
	else
		if attraction >= necrassyPlaces then
			local pos = GetPosition(_IO.Name)
			local rotation = Logic.GetEntityOrientation(GetEntityId(_IO.Name))
			local troop = AI.Entity_CreateFormation(pID,_IO.Offers[i][1],nil,0,pos.X,pos.Y, 0, 0,_IO.Offers[i][9],0)
			Tools.CreateSoldiersForLeader(troop,soldiers)
			Move(troop,troop)
			_IO.Offers[i][2] = _IO.Offers[i][2] -1
			_IO.Button[i].Text = {
				de= "Erwerbt eine Einheit dieses Truppentyps. @cr Noch ".._IO.Offers[i][2].." Einheiten verfügbar. @cr ",
				en = "Buy one battalion of this unit type. @cr Still ".._IO.Offers[i][2].." battalions aviable. @cr "
			}
		else
			Message(Umlaute(Interactive.Standard.NotEnough2[lang]))
			AddGold(pID,_IO.Button[i].Costs[1])
			AddClay(pID,_IO.Button[i].Costs[2])
			AddWood(pID,_IO.Button[i].Costs[3])
			AddStone(pID,_IO.Button[i].Costs[4])
			AddIron(pID,_IO.Button[i].Costs[5])
			AddSulfur(pID,_IO.Button[i].Costs[6])
		end
	end
	if _IO.Offers[i][2] == 0 then
		_IO.Button[i] = nil
	end
	if not _IO.Button[1] and not _IO.Button[2] and not _IO.Button[3] and not _IO.Button[4] and not _IO.Button[5] and not _IO.Button[6] then
		Interactive.Disable(_IO.IO_ID)
	end
end

function Interactive.Control()
	Interactive:HideButton()
	local pID = GUI.GetPlayerID()
	local widget = nil

	for k,v in pairs(Interactive.IO)do
		if Interactive.IO[k] ~= nil then
			if Interactive.IO[k].DoNotShowAMarker == nil or Interactive.IO[k].DoNotShowAMarker == false then
				if IsExisting(Interactive.IO[k].Marker)then
					local posMarker = GetPosition(Interactive.IO[k].Marker)
					local posIO 	= GetPosition(k)
					if posIO.X ~= posMarker.X or posIO.Y ~= posMarker.Y then
						SetPosition(Interactive.IO[k].Marker,posIO)
					end
					Logic.SetModelAndAnimSet( GetEntityId(Interactive.IO[k].Marker), Models.Effects_XF_ExtractStone )
				end
			end

			if XGUIEng.IsWidgetShown("MainMenuLoadWindowCloseButton") == 1 and XGUIEng.IsWidgetShown("GameEndScreen") == 0 then
				if Interactive.ToggleMenu ~= 1 then
					if not Interactive.IO[k].Used and not Interactive.IO[k].Disabled then
						if IsExisting(Interactive.IO[k].Name)then
							-- get camera position
							local camera = {Camera.ScrollGetLookAt()}
							local CPos = {X= camera[1], Y= camera[2]}

							-- add a marker to the IO
							if Interactive.IO[k].DoNotShowAMarker ~= true then
								if GetDistance( CPos, k) < 2000 then
									EnableNpcMarker(GetEntityId(Interactive.IO[k].Marker))
								else
									DisableNpcMarker(GetEntityId(Interactive.IO[k].Marker))
								end
							end

							-- check opener (don't have to be a hero now)
							-- always shown IOs have priority
							if Interactive.IO[k].Opener == nil then
								if GetDistance( CPos, k) < Interactive.IO[k].Range then
									Interactive.ShowButton(Interactive.IO[k],-1)
									widget = Interactive.IO[k].Name
									return
								end
							-- else show objects that need an opener
							else
								if type(Interactive.IO[k].Opener) == "table" then
									for i=1,table.getn(Interactive.IO[k].Opener)do
										local eID = GetEntityId(Interactive.IO[k].Opener[i])
										if IsNear( eID, Interactive.IO[k].Name, Interactive.IO[k].Range)
										and IsEntitySelected(eID) then
											Interactive.ShowButton(Interactive.IO[k],eID)
											widget = Interactive.IO[k].Name
										end
									end
								else
									local eID = GetEntityId(Interactive.IO[k].Opener)
									-- -1 set all settlers as opener
									if Interactive.IO[k].Opener == -1 then
										local found = false
										local pos = GetPosition(Interactive.IO[k].Name)
										local settlers = {Logic.GetPlayerEntitiesInArea(pID,0,pos.X,pos.Y,Interactive.IO[k].Range,16)}
										table.remove(settlers,1)

										for i=1,table.getn(settlers) do
											if (Logic.IsSettler(settlers[i]) == 1 or Logic.IsHero(settlers[i]) == 1) and found == false then
												eID = settlers[i]
												found = true
											end
											--if nothing found return
											if not found then
												return
											end
										end
									end

									if IsNear( eID, Interactive.IO[k].Name, Interactive.IO[k].Range)then
										if Interactive.IO[k].Opener ~= -1 then
											if GetDistance( CPos, Interactive.IO[k].Name) < 2000 then
												Interactive.ShowButton(Interactive.IO[k],eID)
												widget = Interactive.IO[k].Name
											end
										else
											Interactive.ShowButton(Interactive.IO[k],eID)
											widget = Interactive.IO[k].Name
										end
									end
								end
							end
						end
					end
				end
			end
		end
	end
	Interactive.CurrentShown = widget
end

function GiveEntityName(_eID)
    if type(_eID) == "string" then
        return _eID;
    else
        assert(type(_eID) == "number");
        local name = Logic.GetEntityName(_eID);
        if (type(name) ~= "string" or name == "" ) then
            GiveEntityName_EntityNameCounter = (GiveEntityName_EntityNameCounter or 0)+ 1;
            name = "eName_"..GiveEntityName_EntityNameCounter;
            Logic.SetEntityName(_eID,name);
        end
        return name;
    end
end

function CopyTableRecursive(_dest, _source)
	if not _source then
		_source = _dest;
		_dest = {};
	end
	for k, v in pairs(_source) do
		if type(v) == "table" then
			_dest[k] = CopyTableRecursive(v);
		else
			_dest[k] = v;
		end
	end
	return _dest;
end

function Umlaute(_text)
	local texttype = type(_text)
	if texttype == "string" then
		_text = string.gsub( _text, "ä", "\195\164" )
		_text = string.gsub( _text, "ö", "\195\182" )
		_text = string.gsub( _text, "ü", "\195\188" )
		_text = string.gsub( _text, "ß", "\195\159" )
		_text = string.gsub( _text, "Ä", "\195\132" )
		_text = string.gsub( _text, "Ö", "\195\150" )
		_text = string.gsub( _text, "Ü", "\195\156" )
	elseif texttype == "table" then
		for k, v in _text do
			_text[k] = Umlaute( v )
		end
	end
	return _text
end

INTERACTIVE_CONTROL_INTERACTIVES = Interactive.Control;


Interactive.Default					= "QuestWindowCloseButton"
Interactive.Language 				= "de"
Interactive.CurrentShown 			= ""

Interactive.Standard 				= {}
Interactive.Standard.NotEnough1		= { de = "Ihr habt nicht genug Rohstoffe!", en = "You have not enough resources!", }
Interactive.Standard.NotEnough2		= { de = "Nicht genug Platz im Dorfzentrum!", en = "Your village centers are full!", }

Interactive.Standard.Chest 			= {}
Interactive.Standard.Chest.Found	= { de = "Ihr habt einige Rohstoffe gefunden!", en = "You have found some resources", }
Interactive.Standard.Chest.Title 	= { de = "Schatztruhe", en = "Treasure Chest", }
Interactive.Standard.Chest.Text 	= { de = "In dieser Truhe befindet sich ein Schatz.", en = "This chest hold a treasures.", }

Interactive.Standard.Gate 			= {}
Interactive.Standard.Gate.Title 	= { de = "Tor", en = "Gate", }
Interactive.Standard.Gate.Text 		= { de = "Dieses Tor kann bedient werden.", en = "This gate is useable.", }

Interactive.Standard.Custom = {}
Interactive.Standard.Custom.Title 	= { de = "Interaktion", en = "Interaction", }
Interactive.Standard.Custom.Text 	= { de = "Interaktion möglich.", en = "Interaction possible.", }

Interactive.Buttons = {}
Interactive.Buttons.Standard = "QuestWindowCloseButton"

Interactive.Buttons.Bag = "BlessSettlers4"
Interactive.Buttons.Chest = "Levy_Duties"
Interactive.Buttons.Lock = "Research_Banking"
Interactive.Buttons.Clay = "Statistics_SubResources_Clay"
Interactive.Buttons.Faith = "Build_Monastery"
Interactive.Buttons.Gold = "Statistics_SubResources_Money"
Interactive.Buttons.Iron = "Statistics_SubResources_Iron"
Interactive.Buttons.Minus = "Trade_Market_DecreaseSulfur"
Interactive.Buttons.Plus = "Trade_Market_IncreaseSulfur"
Interactive.Buttons.Stone = "Statistics_SubResources_Stone"
Interactive.Buttons.Sulfur = "Statistics_SubResources_Sulphur"
Interactive.Buttons.Wood = "Statistics_SubResources_Wood"

Interactive.Buttons.Pos 			= {
	{566, 616, 475, 515},
	{636, 676, 475, 515},
	{710, 756, 475, 515},
	{766, 806, 475, 515},
	{836, 876, 475, 515},
	{916, 956, 475, 515},
}

Interactive.ResourceCount 			= {
	[ResourceType.Clay] 	 = 1,
	[ResourceType.Wood] 	 = 2,
	[ResourceType.Stone] 	 = 3,
	[ResourceType.Iron] 	 = 4,
	[ResourceType.Sulfur] 	 = 5,
	[ResourceType.ClayRaw] 	 = 1,
	[ResourceType.WoodRaw] 	 = 2,
	[ResourceType.StoneRaw]  = 3,
	[ResourceType.IronRaw] 	 = 4,
	[ResourceType.SulfurRaw] = 5,
}

Interactive.Mercenary 				= {
	-- you can add here more entities
	-- [entityType]	= {	{ de = "description german", en = "description english"}  ,  number of soldiers  ,   button texture	}, -- don't forget the ','

	--[Entities.CU_AggressiveWolf] 			= {{de="Wolf", en="Wolf"},0,"MultiSelectionSource_LightCav"},
	[Entities.CU_Evil_LeaderSkirmisher1]	= {{de="Speerwerfer", en="Skirmisher"},16,"MultiSelectionSource_Bow"},
	[Entities.CU_Evil_LeaderBearman1] 		= {{de="Bärenmensch", en="Bearmen"},16,"MultiSelectionSource_Sword"},
	[Entities.CU_BlackKnight_LeaderMace2] 	= {{de="Schwarzer Ritter", en="Black Knight"},4,"MultiSelectionSource_Sword"},
	[Entities.CU_BanditLeaderSword2] 		= {{de="Anführer der Banditen", en="Captain of the Bandits"},8,"MultiSelectionSource_Sword"},
	[Entities.CU_BanditLeaderBow1] 			= {{de="Banditenbogenschützen", en="Bandit Archers"},4,"MultiSelectionSource_Bow"},

	[Entities.PU_LeaderHeavyCavalry1] 		= {{de="Berittener Kurzschwertkämpfer", en="Mounted Shortswordmen"},3,"MultiSelectionSource_HeavyCav"},
	[Entities.PU_LeaderHeavyCavalry2] 		= {{de="Berittener Streitaxtkämpfer", en="Mounted Axemen"},3,"MultiSelectionSource_HeavyCav"},
	[Entities.PU_LeaderCavalry1] 			= {{de="Berittener Kurzbogenschütze", en="Mounted Shortbowmen"},3,"MultiSelectionSource_LightCav"},
	[Entities.PU_LeaderCavalry2] 			= {{de="Berittener Armbrustschütze", en="Mounted Crossbowmen"},3,"MultiSelectionSource_LightCav"},
	[Entities.PU_LeaderRifle1] 				= {{de="Leichter Scharfschütze", en="Light Riflemen"},4,"MultiSelectionSource_Rifle"},
	[Entities.PU_LeaderRifle2]				= {{de="Schwerer Scharfschütze", en="Heavy Riflemen"},8,"MultiSelectionSource_Rifle"},
	[Entities.PU_LeaderBow1] 				= {{de="Kurzbogenschütze", en="Shortbowmen"},4,"MultiSelectionSource_Bow"},
	[Entities.PU_LeaderBow2] 				= {{de="Langbogenschütze", en="Longbowmen"},4,"MultiSelectionSource_Bow"},
	[Entities.PU_LeaderBow3] 				= {{de="Armbrustschütze", en="Crossbowmen"},8,"MultiSelectionSource_Bow"},
	[Entities.PU_LeaderBow4] 				= {{de="Arbalestenschütze", en="Arbalestsmen"},8,"MultiSelectionSource_Bow"},
	[Entities.PU_LeaderSword1] 				= {{de="Kurzschwertkämpfer", en="Shortswordmen"},4,"MultiSelectionSource_Sword"},
	[Entities.PU_LeaderSword2] 				= {{de="Breitschwertkämpfer", en="Broadswordsmen"},4,"MultiSelectionSource_Sword"},
	[Entities.PU_LeaderSword3] 				= {{de="Langschwertkämpfer", en="Longswordmen"},8,"MultiSelectionSource_Sword"},
	[Entities.PU_LeaderSword4] 				= {{de="Bastardschwertkämpfer", en="Bastard Swordmen"},8,"MultiSelectionSource_Sword"},
	[Entities.PU_LeaderPoleArm1] 			= {{de="Langspeerträger", en="Longspearmen"},4,"MultiSelectionSource_Spear"},
	[Entities.PU_LeaderPoleArm2] 			= {{de="Lanzenträger", en="Lancers"},4,"MultiSelectionSource_Spear"},
	[Entities.PU_LeaderPoleArm3] 			= {{de="Streitlanzenträger", en="Armed Lancers"},8,"MultiSelectionSource_Spear"},
	[Entities.PU_LeaderPoleArm4] 			= {{de="Hellebardier", en="Halberdiers"},8,"MultiSelectionSource_Spear"},
	[Entities.PV_Cannon1] 					= {{de="Bombarde", en="Bombard"},0,"MultiSelectionSource_Cannon"},
	[Entities.PV_Cannon2] 					= {{de="Bronzekanone", en="Bronze Cannon"},0,"MultiSelectionSource_Cannon"},
	[Entities.PV_Cannon3] 					= {{de="Eisenkanone", en="Iron Cannon"},0,"MultiSelectionSource_Cannon"},
	[Entities.PV_Cannon4] 					= {{de="Belagerungskanone", en="Siege Cannon"},0,"MultiSelectionSource_Cannon"},

	[Entities.PU_Serf] 						= {{de="Leibeigener", en="Serf"},0,"MultiSelectionSource_Serf"},
	[Entities.PU_Scout] 					= {{de="Kundschafter", en="Scout"},0,"MultiSelectionSource_Scout"},
	[Entities.PU_Thief] 					= {{de="Dieb", en="Thief"},0,"MultiSelectionSource_Thief"},
}

Tradepost.Title 			= { de = "Handelsposten", en = "Trade Post" }
Tradepost.Text1 			= { de = "Kauft 250 Einheiten dieses Rohstoffes.", en = "Buy 250 units of this resource.",}
Tradepost.Text2 			= { de = "Verkauft diesen Rohstoff für 250 Taler.", en = "Sell this resource for 250 Thalers.",}
Tradepost.Text3 			= { de = "Wechselt zwischen kaufen und verkaufen.", en = "Change between buy and sell.",}
Tradepost.Money 			= { de = "Taler", en = "Thalers",}
Tradepost.Clay  			= { de = "Lehm", en = "Clay",}
Tradepost.Wood  			= { de = "Holz", en = "Wood",}
Tradepost.Stone 			= { de = "Stein", en = "Stone",}
Tradepost.Iron   			= { de = "Eisen", en = "Iron",}
Tradepost.Sulfur 			= { de = "Schwefel", en = "Sulphur",}

Tradepost.TransactionBuy 	= {0,0,0,0,0}
Tradepost.TransactionSell 	= {0,0,0,0,0}
Tradepost.PriceBuy 			= {300,185,310,375,295}
Tradepost.PriceSell 		= {460,560,420,440,500}
Tradepost.Inflation 		= 5
Tradepost.Deflation 		= 3

function GibTTGold( _amount, _id )
	if not type(_id) == "number" then
		_id = 1;
	end
	local da = GetGold(_id)
	if da < _amount then
		return " @color:255,32,32 ".._amount.." @color:255,255,255 "
	end
	return tostring(_amount)
end
function GibTTLehm( _amount, _id )
	if not type(_id) == "number" then
		_id = 1;
	end
	local da = GetClay(_id)
	if da < _amount then
		return " @color:255,32,32 ".._amount.." @color:255,255,255 "
	end
	return tostring(_amount)
end
function GibTTHolz( _amount, _id )
	if not type(_id) == "number" then
		_id = 1;
	end
	local da = GetWood(_id)
	if da < _amount then
		return " @color:255,32,32 ".._amount.." @color:255,255,255 "
	end
	return tostring(_amount)
end
function GibTTStein( _amount, _id )
	if not type(_id) == "number" then
		_id = 1;
	end
	local da = GetStone(_id)
	if da < _amount then
		return " @color:255,32,32 ".._amount.." @color:255,255,255 "
	end
	return tostring(_amount)
end
function GibTTEisen( _amount, _id )
	if not type(_id) == "number" then
		_id = 1;
	end
	local da = GetIron(_id)
	if da < _amount then
		return " @color:255,32,32 ".._amount.." @color:255,255,255 "
	end
	return tostring(_amount)
end
function GibTTSchwefel( _amount, _id )
	if not type(_id) == "number" then
		_id = 1;
	end
	local da = GetSulfur(_id)
	if da < _amount then
		return " @color:255,32,32 ".._amount.." @color:255,255,255 "
	end
	return tostring(_amount)
end